<?php

require("config.php");


$ruta = $_SERVER['REQUEST_URI'];
$paths = explode("/", $ruta);
$method = $_SERVER['REQUEST_METHOD'];
$headers = apache_request_headers();
$token = $headers['Api-Key'];

if( empty($token) || !preg_match("/^[A-Za-z0-9]$/", $token) )
{
	header('HTTP/1.1 401 Not Found');
}


array_shift($paths);
$script = array_shift($paths);
$resource = array_shift($paths);
if($resource == 'correos'){
    $name = array_shift($paths);
    if(empty($name)){
        handle_base($method);
    } else {
        handle_name($method, $name);
    }
} else {
    // Slo se aceptan resources desde 'correos'
    header('HTTP/1.1 404 Not Found');
}

function handle_base()
{
	
}

function handle_name($method, $name = null)
{
	switch($method)
	{
		case 'PUT':
			create_email($name);
			break;
		case 'DELETE':
			//delete_email($name);
			break;
		case 'GET':
			display_email($name);
			break;
		case 'SET':
			update_email($name);
			break;
		default:
			header('HTTP/1.1 405 Method not allowed');
			header('Allow: GET, PUT');
			break;
	}
}


function display_email($user)
{
	$res = getpop( array("user" => $user));
	if( (int)$res["status"] == 1 )
	{
		echo json_encode($res["data"]);
	}
	else
	{
		if( preg_match("/Usted no tiene una cuenta de correo/", $res["errors"][0] ) )
		{
			header('HTTP/1.1 404');
		}
		else
		{
			header('HTTP/1.1 500');			
		}
	}
}

function create_email($user)
{
	global $domain;
	
	$data = json_decode(file_get_contents('php://input'), true);
	
	if( empty($user) || !preg_match("/^[A-Za-z0-9]*$/", $user) )
	{
		header('HTTP/1.1 400');
		return;		
	}
	
	if( !isset($data["quota"]) || !isset($data["pass"]) )
	{
		header('HTTP/1.1 400');
		return;
	}
	
	$params["user"] = $user . "@" . $domain;
	$params["pass"] = $data["pass"];
	if( isset($data["quota"]) )
	{
		$params["quota"] = $data["quota"];
	}
	else
	{
		$params["quota"] = 20000;
	}
	$res = addpop($params);
	
	if( (int)$res["status"] == 1 )
	{
		header('HTTP/1.1 201');
	}
	else
	{
		if( preg_match("/already exists/", $res["errors"][0] ) )
		{
			header('HTTP/1.1 409');
		}
		else
		{
			header('HTTP/1.1 503');
		}
	}
}
	
function update_email($user)
{
	global $domain;
	
	$data = json_decode(file_get_contents('php://input'), true);
	
	if( empty($user) || !preg_match("/^[A-Za-z0-9]*$/", $user) )
	{
		header('HTTP/1.1 400');
		return;		
	}
	
	if( !isset($data["pass"]) )
	{
		header('HTTP/1.1 400');
		return;
	}
	
	$params["user"] = $user . "@" . $domain;
	$params["pass"] = $data["pass"];
	$res = updatepop($params);
	
	if( (int)$res["status"] == 1 )
	{
		header('HTTP/1.1 201');
	}
	else
	{
		if( preg_match("/already exists/", $res["errors"][0] ) )
		{
			header('HTTP/1.1 409');
		}
		else
		{
			header('HTTP/1.1 503');
		}
	}
}

function addpop($params)
{
	global $URL;
	global $token;
	global $domain;
	global $usutoken;
	
	$user = $params["user"];
	$pass = $params["pass"];
	$quota = $params["quota"];

		
	$query = $URL . "execute/Email/add_pop?email=".urlencode($user)."&domain=".urlencode($domain)."&password=" .urlencode($pass)."&quota=" . $quota; //"/json-api/cpanel?cpanel_jsonapi_user=user&cpanel_jsonapi_apiversion=2&cpanel_jsonapi_module=Email&cpanel_jsonapi_func=addpop&domain=".$domain."&email=".$user."&password=".urlencode($pass);
		
	$curl = curl_init();
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,0);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
	  
	$header[0] = "Authorization: cpanel ".$usutoken.":" . $token;
	curl_setopt($curl,CURLOPT_HTTPHEADER,$header);
	curl_setopt($curl, CURLOPT_URL, $query);
	  
	$result = curl_exec($curl);
	if ($result == false) {
		error_log("curl_exec threw error \"" . curl_error($curl) . "\" for $query");
	}
	curl_close($curl);
	
	if( preg_match("/Access denied/", $result)  )
	{
		header('HTTP/1.1 401');
		exit(0);
	}
	  
	$resjson = json_decode( $result, true);
	return $resjson;
}

function updatepop($params)
{
	global $URL;
	global $token;
	global $domain;
	global $usutoken;
	
	$user = $params["user"];
	$pass = $params["pass"];

		
	$query = $URL . "execute/Email/passwd_pop?email=".urlencode($user)."&password=" .urlencode($pass); 
		
	$curl = curl_init();
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,0);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
	  
	$header[0] = "Authorization: cpanel ".$usutoken.":" . $token;
	curl_setopt($curl,CURLOPT_HTTPHEADER,$header);
	curl_setopt($curl, CURLOPT_URL, $query);
	  
	$result = curl_exec($curl);
	if ($result == false) {
		error_log("curl_exec threw error \"" . curl_error($curl) . "\" for $query");
	}
	curl_close($curl);
	
	if( preg_match("/Access denied/", $result)  )
	{
		header('HTTP/1.1 401');
		exit(0);
	}
	  
	$resjson = json_decode( $result, true);
	return $resjson;
}

function getpop($params)
{

	global $URL;
	global $domain;
	global $token;
	global $usutoken;
	
	$user = $params["user"];
		
	$query = $URL . "execute/Email/get_disk_usage?domain=".$domain."&user=" .$user;
		
	$curl = curl_init();
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,0);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
	  
	$header[0] = "Authorization: cpanel ".$usutoken.":" . $token;
	curl_setopt($curl,CURLOPT_HTTPHEADER,$header);
	curl_setopt($curl, CURLOPT_URL, $query);
	  
	$result = curl_exec($curl);
	if ($result == false) {
		error_log("curl_exec threw error \"" . curl_error($curl) . "\" for $query");
	}
	curl_close($curl);
	
	if( preg_match("/Access denied/", $result)  )
	{
		header('HTTP/1.1 401');
		exit(0);
	}
	
	
	$resjson = json_decode( $result, true);
	return $resjson;
}


?>
